#! /usr/bin/ruby

require 'rbconfig'

commands = [
            "tcrtest.rb write -tout 3 127.0.0.1 10000",
            "tcrtest.rb read -tout 3 127.0.0.1",
            "tcrtest.rb remove -tout 3 127.0.0.1",
            "tcrtest.rb rcat -tout 3 127.0.0.1 1000",
            "tcrtest.rb rcat -tout 3 -shl 10 127.0.0.1 1000",
            "tcrtest.rb rcat -tout 3 -dai 127.0.0.1 1000",
            "tcrtest.rb rcat -tout 3 -ext put 127.0.0.1 1000",
            "tcrtest.rb misc -tout 3 127.0.0.1 1000",
           ]
rubycmd = Config::CONFIG["bindir"] + "/" + RbConfig::CONFIG['ruby_install_name']
num = 1
commands.each do |command|
  rv = system("#{rubycmd} #{command} >/dev/null")
  if rv
    printf("%03d/%03d: %s: ok\n", num, commands.size, command)
  else
    printf("%03d/%03d: %s: failed\n", num, commands.size, command)
    exit(1)
  end
  num += 1
end
printf("all ok\n")

system("rm -rf casket")
