/*************************************************************************************************
 * Interface of features of regular expression
 *                                                      Copyright (C) 2003-2006 Mikio Hirabayashi
 * This file is part of Estraier, a personal full-text search system.
 * Estraier is free software; you can redistribute it and/or modify it under the terms of the GNU
 * General Public License as published by the Free Software Foundation; either version 2 of the
 * License, or any later version.
 * Estraier is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License along with Estraier;
 * if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA.
 *************************************************************************************************/


#ifndef _ESTREGEX_H                      /* duplication check */
#define _ESTREGEX_H



/*************************************************************************************************
 * functions
 *************************************************************************************************/


/* Check whether a regular expression matches a string.
   `str' specifies a target string.
   `regex' specifies the string of a regular expression.  If it is `NULL', the last specified
   expression is used.
   The return value is true if the regular expression matches the candidate, else, it is false. */
extern int (*estregexmatch)(const char *str, const char *regex);



#endif                                   /* duplication check */


/* END OF FILE */
