/*************************************************************************************************
 * Implementation of features of regular expression
 *                                                      Copyright (C) 2003-2006 Mikio Hirabayashi
 * This file is part of Estraier, a personal full-text search system.
 * Estraier is free software; you can redistribute it and/or modify it under the terms of the GNU
 * General Public License as published by the Free Software Foundation; either version 2 of the
 * License, or any later version.
 * Estraier is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License along with Estraier;
 * if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA.
 *************************************************************************************************/


#include "estcommon.h"



#if defined(MYREGEX)
/*************************************************************************************************
 * implementations
 *************************************************************************************************/


#include <regex.h>


static int estislastpreg = FALSE;
static regex_t estlastpreg;


static int estregexmatch_impl(const char *str, const char *regex);
static void estfreelastpreg(void);


int estisregex = TRUE;
int (*estregexmatch)(const char *str, const char *regex) = estregexmatch_impl;


/* Check whether a regular expression matches a string. */
static int estregexmatch_impl(const char *str, const char *regex){
  static int first = TRUE;
  if(first){
    atexit(estfreelastpreg);
    first = FALSE;
  }
  if(regex){
    estfreelastpreg();
    if(regcomp(&estlastpreg, regex, REG_EXTENDED) != 0) return FALSE;
    estislastpreg = TRUE;
  } else if(!estislastpreg){
    return FALSE;
  }
  if(regexec(&estlastpreg, str, 0, NULL, 0) == 0) return TRUE;
  return FALSE;
}


/* Free resources of the last precompiled pattern buffer. */
static void estfreelastpreg(void){
  if(estislastpreg){
    regfree(&estlastpreg);
    estislastpreg = FALSE;
  }
}



#else
/*************************************************************************************************
 * dummy interfaces
 *************************************************************************************************/


int estisregex = FALSE;
int (*estregexmatch)(const char *str, const char *regex) = NULL;



#endif



/* END OF FILE */
