/*************************************************************************************************
 * Interface of CJK uni-gram analyzing features
 *                                                      Copyright (C) 2003-2006 Mikio Hirabayashi
 * This file is part of Estraier, a personal full-text search system.
 * Estraier is free software; you can redistribute it and/or modify it under the terms of the GNU
 * General Public License as published by the Free Software Foundation; either version 2 of the
 * License, or any later version.
 * Estraier is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License along with Estraier;
 * if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA.
 *************************************************************************************************/


#ifndef _ESTCJKUNI_H                     /* duplication check */
#define _ESTCJKUNI_H



/*************************************************************************************************
 * functions
 *************************************************************************************************/


/* Break a CJK text into words and register them to a document handle, by uni-gram method.
   `doc' specifies a document handle.
   `text' specifies a text whose encoding is UTF-16BE.
   `size' specifies the size of the text.
   `mode' specifies detailed behavior. */
extern void (*estdocaddtextcjkuni)(ODDOC *doc, const char *text, int size, int mode);



#endif                                   /* duplication check */


/* END OF FILE */
